/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.entity.ai.GoomSmokeGoal;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class GoomEntity
extends GoblinEntity {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(GoomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(GoomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(GoomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BLOWN = SynchedEntityData.m_135353_(GoomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int timeTillBomb = 0;

    public GoomEntity(EntityType<? extends GoomEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new GoomSmokeGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 25.0);
    }

    protected SoundEvent m_7515_() {
        return SoundInit.GOOM_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundInit.GOOM_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.GOOM_DEATH;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_142538_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.nextFloat() < f * 0.3f) {
                entityIn.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    public boolean isBlownUp() {
        return (Boolean)this.f_19804_.m_135370_(BLOWN);
    }

    public void setBlownUp(boolean isBlownUp) {
        this.f_19804_.m_135381_(BLOWN, (Object)isBlownUp);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
        this.f_19804_.m_135372_(BLOWN, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setGoomState(1);
            }
            if ((i = this.getGoomState()) > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_(SoundInit.GOOM_WARNING, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                if (!this.isBlownUp()) {
                    this.explode();
                }
            }
            if (this.isBlownUp()) {
                ++this.timeTillBomb;
                if (this.timeTillBomb >= 6000) {
                    this.ignite(false);
                    this.setBlownUp(false);
                    BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.f_19853_.m_5594_(null, pos, SoundEvents.f_11773_, SoundSource.HOSTILE, 0.3f, 0.5f);
                }
            }
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBlownUp(compound.m_128471_("IsBlownUp"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compound) {
        spawnData = super.m_6518_(worldIn, difficulty, reason, spawnData, compound);
        return spawnData;
    }

    public int getGoomState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setGoomState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    protected InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() == Items.f_42409_) {
            this.f_19853_.m_6263_(p_230254_1_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite(true);
                itemstack.m_41622_(1, (LivingEntity)p_230254_1_, player -> player.m_21190_(p_230254_2_));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    private void explode() {
        if (!this.f_19853_.f_46443_) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(2.5f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123778_);
            this.setBlownUp(true);
            BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.f_19853_.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.HOSTILE, 0.3f, 0.5f);
            this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite(boolean hasIgnited) {
        this.f_19804_.m_135381_(IGNITED, (Object)hasIgnited);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ItemInit.GOOM_SPAWN_EGG.get());
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == CreatureAttributeInit.GOBLIN) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public class PostExplosionAttackGoal
    extends MeleeAttackGoal {
        public PostExplosionAttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean m_8036_() {
            return GoomEntity.this.isBlownUp() && super.m_8036_();
        }

        public boolean m_8045_() {
            return GoomEntity.this.isBlownUp() && super.m_8045_();
        }
    }
}

